
static u32 OSK_KeyMapSelector_ItemIndex;

static void OSK_KeyMapSelector_MouseMove(s32 mx,s32 my)
{
  if(my<32){
    if(mx<(ScreenWidth-48)){
      OSK_KeyMapSelector_ItemIndex=(u32)-1;
      }else{
      OSK_KeyMapSelector_ItemIndex=OSK_KeyMaps_GetKeyMapIndex();
    }
    return;
  }
  
  s32 y=32;
  s32 h=24;
  
  OSK_KeyMapSelector_ItemIndex=(my-y)/h;
  if(KeyMapsCount<=OSK_KeyMapSelector_ItemIndex) OSK_KeyMapSelector_ItemIndex=(u32)-1;
}

static void OSK_KeyMapSelector_DrawScreen(CglCanvas *pcan)
{
  const u16 BGColor=RGB15(16,16,16)|BIT15;
  const u16 TextColor=RGB15(8,8,8)|BIT15;
  const u16 BGHighColor=RGB15(8,8,16)|BIT15;
  const u16 TextHighColor=RGB15(31,31,31)|BIT15;
  
  u32 y=32;
  const u32 h=24;
  
  const u32 th=glCanvasTextHeight+2;
  
  u32 x=0;
  for(u32 idx=0;idx<KeyMapsCount;idx++){
    const UnicodeChar *pstr=KeyMaps[idx].GlobalInfo.pTitle;
    u32 tw=pcan->GetTextWidthW(pstr)+4;
    if(x<tw) x=tw;
  }
  x+=48;
  if(ScreenWidth<x) x=ScreenWidth;
  x=ScreenWidth-x;
  
  const u32 w=ScreenWidth-x;
  
  for(u32 idx=0;idx<KeyMapsCount;idx++){
    const UnicodeChar *pstr=KeyMaps[idx].GlobalInfo.pTitle;
    pScreenMain->pBackCanvas->BitBlt(pcan,x,y,w,h,x,y,false);
    if(idx==OSK_KeyMapSelector_ItemIndex){
      OnSkin_FillBox75per(pcan,x,y,w,h,BGHighColor);
      pcan->SetFontTextColor(TextHighColor);
      }else{
      OnSkin_FillBox25per(pcan,x,y,w,h,BGColor);
      pcan->SetFontTextColor(TextColor);
    }
    u32 tx=x+4,ty=y+((h-th)/2);
    pcan->TextOutW(tx,ty,pstr);
    if(idx==OSK_KeyMaps_GetKeyMapIndex()){
      u32 tw=pcan->GetTextWidthW(pstr)+8;
      pcan->TextOutA(tx+tw,ty,"*");
    }
    y+=h;
  }
  
}

#include "_GlobalTool_DirectPenRead.h"

static u32 OSK_KeyMapSelector_Execute(void)
{
  OSK_KeyMapSelector_ItemIndex=OSK_KeyMaps_GetKeyMapIndex();
  u32 lastidx=OSK_KeyMapSelector_ItemIndex;
  
  pScreenMainOverlay->pCanvas->BitBlt(pScreenMain->pViewCanvas,0,0,ScreenWidth,ScreenHeight,0,0,true);
  pScreenMainOverlay->pCanvas->FillFull(0);
  
//  OSK_KeyMapSelector_DrawScreen(pScreenMainOverlay->pCanvas);
  
  pSkinOSKBG->BitBltFullBeta(pScreenMain->pBackCanvas);
  u32 fadelevel=0;
  
  s32 mx=0,my=0;
  
  OSK_KeyMapSelector_DrawScreen(pScreenMainOverlay->pCanvas);
  
  while(1){
    if(VBlankPassedFlag==false){
      while(VBlankPassedFlag==false){
        swiWaitForIRQ();
      }
    }
    VBlankPassedFlag=false;
    
    const TDirectPenInfo pen=DirectPenRead_FromNowPosition();
    if(pen.CanRead==true){
      mx=pen.x;
      my=pen.y;
      if(pen.PenDown==false) break;
      OSK_KeyMapSelector_MouseMove(mx,my);
    }
    
    if(lastidx!=OSK_KeyMapSelector_ItemIndex){
      PlaySE_Short();
      lastidx=OSK_KeyMapSelector_ItemIndex;
      OSK_KeyMapSelector_DrawScreen(pScreenMainOverlay->pCanvas);
    }
    
    if(fadelevel<64){
      fadelevel++;
      pScreenMain->SetBlendLevel(16-(fadelevel/4));
    }
  }
  
  if(my<32){
    if(mx<(ScreenWidth-48)){
      }else{
      OSK_KeyMapSelector_ItemIndex++;
      if(OSK_KeyMapSelector_ItemIndex==KeyMapsCount) OSK_KeyMapSelector_ItemIndex=0;
    }
  }
  
  pScreenMainOverlay->pCanvas->FillFull(0);
  
  pScreenMain->Flip(true);
  
  if(OSK_KeyMapSelector_ItemIndex!=(u32)-1) return(OSK_KeyMapSelector_ItemIndex);
  
  return((u32)-1);
}
